/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.commands;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import net.skinsrestorer.shadow.aikar.commands.BungeeCommandManager;
import net.skinsrestorer.shadow.aikar.commands.Locales;
import net.skinsrestorer.shadow.aikar.locales.MessageKey;

public class BungeeLocales
extends Locales {
    private final BungeeCommandManager manager;

    public BungeeLocales(BungeeCommandManager manager) {
        super(manager);
        this.manager = manager;
        this.addBundleClassLoader(this.manager.getPlugin().getClass().getClassLoader());
    }

    @Override
    public void loadLanguages() {
        super.loadLanguages();
        String pluginName = "acf-" + this.manager.plugin.getDescription().getName();
        this.addMessageBundles("acf-minecraft", pluginName, pluginName.toLowerCase(Locale.ENGLISH));
    }

    public boolean loadYamlLanguageFile(File file, Locale locale) throws IOException {
        Configuration yamlConfiguration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file);
        return this.loadLanguage(yamlConfiguration, locale);
    }

    public boolean loadYamlLanguageFile(String file, Locale locale) throws IOException {
        Configuration yamlConfiguration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(this.manager.plugin.getDataFolder(), file));
        return this.loadLanguage(yamlConfiguration, locale);
    }

    public boolean loadLanguage(Configuration config, Locale locale) {
        boolean loaded = false;
        for (String parentKey : config.getKeys()) {
            Configuration inner = config.getSection(parentKey);
            if (inner == null) continue;
            for (String key : inner.getKeys()) {
                String value = inner.getString(key);
                if (value == null || value.isEmpty()) continue;
                this.addMessage(locale, MessageKey.of(parentKey + "." + key), value);
                loaded = true;
            }
        }
        return loaded;
    }
}

